var widths = [];
widths[0] = 100;
widths[1] = 50;
widths[2] = 33.33;
widths[3] = 25;
widths[4] = 20;
widths[5] = 16.66;

(function(jQuery){
    jQuery.widget('ui.combobox', {
        _create: function () {
            var e = this,
                select = this.element.hide(),
                selected = select.children(':selected'),
                value = selected.val() ? selected.text() : '';
            var f = this.input = jQuery('<input>').attr('size', 25).insertAfter(select).val(value).autocomplete({
                delay: 0,
                minLength: 0,
                source: function (b, c) {
                    var d = new RegExp(jQuery.ui.autocomplete.escapeRegex(b.term), 'i');
                    r = select.children('option').size();
                    c(select.children('option').map(function () {
                        var a = jQuery(this).text();
                        if (this.value && (!b.term || d.test(a))) {
                            return {
                                label: a.replace(new RegExp('(?![^&;]+;)(?!<[^<>]*)(' + jQuery.ui.autocomplete.escapeRegex(b.term) + ')(?![^<>]*>)(?![^&;]+;)', 'gi'), '<strong>$1</strong>'),
                                value: a,
                                option: this
                            }
                        }
                    }))
                },
                select: function (a, b) {
                  //console.log(a, a.target, b.item);
                  if(jQuery(a.target).prev('select')) jQuery(document).trigger('select_change', {select: jQuery(a.target).prev('select'), value: b.item.value});
                    b.item.option.selected = true;
                    e._trigger('selected', a, {
                        item: b.item.option
                    });
                    if(select.attr('id').match('fonts') || select.attr('id').match('font')) {
                        jQuery(document).unbind('mousemove');
                        jQuery("#font_preview").hide().css({
                            top: 0,
                            left: 0,
                        });
                    }
                },
                focus: function (a, b) {
                    if(select.attr('id').match('fonts') || select.attr('id').match('font')) {
                        jQuery().previewFonts(b.item.label);
                        jQuery(document).bind('mousemove', function(e){
                            jQuery("#font_preview").show();
                            jQuery("#font_preview").css({
                                top: (e.pageY - 15),
                                left: (e.pageX + 15),
                            });
                        });
                    }
                },
                close: function (a, b) {
                    if(select.attr('id').match('fonts') || select.attr('id').match('font')) {
                        jQuery(document).unbind('mousemove');
                        jQuery("#font_preview").hide().css({
                            top: 0,
                            left: 0
                        });
                    }
                },
                open: function (a, b) {},
                change: function (a, b) {
                    if (!b.item) {
                        var c = new RegExp('^' + jQuery.ui.autocomplete.escapeRegex(jQuery(this).val()) + '$', 'i'), valid = false;
                        select.children('option').each(function () {
                            if (jQuery(this).text().match(c)) {
                                this.selected = valid = true;
                                return false;
                            }
                        });
                        if (!valid) {
                            jQuery(this).val('');
                            select.val('');
                            f.data('autocomplete').term = '';
                            return false;
                        }
                    }
                    if(select.attr('id').match('fonts') || select.attr('id').match('font')) {
                        jQuery(document).unbind('mousemove');
                        jQuery("#font_preview").hide().css({
                            top: 0,
                            left: 0,
                        });
                    }
                }
            }).addClass('ui-widget ui-widget-content ui-corner-left');
            f.data('autocomplete')._renderItem = function (a, b) {
                return jQuery('<li></li>').data('item.autocomplete', b).append('<a>' + b.label + '</a>').appendTo(a)
            };
            this.button = jQuery('<' + 'div />').addClass('drop-button').attr('title', 'Show All Items').insertAfter(f).click(function () {
                if (f.autocomplete('widget').is(':visible')) {
                    f.autocomplete('close');
                    return
                }
                jQuery(this).blur();
                f.autocomplete('search', '');
                f.focus()
            })
        },
        destroy: function () {
            this.input.remove();
            this.button.remove();
            this.element.show();
            jQuery.Widget.prototype.destroy.call(this)
        }
    });
    jQuery.widget('ui.sizeslider', {
        options: {
            width: 180,
            curval: 0,
            id: null
        },
        _create: function () {
            var e = this,
                returnVal = 0,
                select = this.element.hide(),
                selected = select.children(':selected'),
                value = selected.val() ? selected.val() : '';
            var f = this.input = jQuery('<input>').attr('size', 25).insertAfter(select).val(value).autocomplete({
                delay: 0,
                minLength: 0,
                source: function (b, c) {
                    var d = new RegExp(jQuery.ui.autocomplete.escapeRegex(b.term), 'i');
                    r = select.children('option').size();
                    c(select.children('option').map(function () {
                        var a = jQuery(this).text();
                        if (this.value && (!b.term || d.test(a))) {
                            return {
                                label: a.replace(new RegExp('(?![^&;]+;)(?!<[^<>]*)(' + jQuery.ui.autocomplete.escapeRegex(b.term) + ')(?![^<>]*>)(?![^&;]+;)', 'gi'), '<strong>$1</strong>'),
                                value: a,
                                option: this
                            }
                        }
                    }))
                },
                select: function (a, b) {
                    b.item.option.selected = true;
                    e._trigger('selected', a, {
                        item: b.item.option
                    })
                },
                open: function (a, b) {},
                change: function (a, b) {
                    if (!b.item) {
                        var c = new RegExp('^' + jQuery.ui.autocomplete.escapeRegex(jQuery(this).val()) + '$', 'i'),
                            valid = false;
                        select.children('option').each(function () {
                            if (jQuery(this).text().match(c)) {
                                this.selected = valid = true;
                                return false
                            }
                        });
                        if (!valid) {
                            jQuery(this).val('');
                            select.val('');
                            f.data('autocomplete').term = '';
                            return false
                        }
                    }
                    e._trigger("change", null, jQuery(this).val())
                }
            }).addClass('ui-widget ui-widget-content ui-corner-left');
            jQuery(f).bind("autocompleteselect", function (a, b) {
                select.children('option').each(function () {
                    if (jQuery(this).val().match(/1|2|3|4|5|6/i)) {
                        if (b.item.value.match(/1/i)) {
                            returnVal = 1
                        } else if (b.item.value.match(/2/i)) {
                            returnVal = 2
                        } else if (b.item.value.match(/3/i)) {
                            returnVal = 3
                        } else if (b.item.value.match(/4/i)) {
                            returnVal = 4
                        } else if (b.item.value.match(/5/i)) {
                            returnVal = 5
                        } else if (b.item.value.match(/6/i)) {
                            returnVal = 6
                        }
                        e.options.curval = returnVal
                    }
                })
            });
            f.data('autocomplete')._renderItem = function (a, b) {
                return jQuery('<li></li>').data('item.autocomplete', b).append('<a>' + b.label + '</a>').appendTo(a)
            };
            this.button = jQuery('<' + 'div />').addClass('drop-button').attr('title', 'Show All Items').insertAfter(f).click(function () {
                if (f.autocomplete('widget').is(':visible')) {
                    f.autocomplete('close');
                    return
                }
                jQuery(this).blur();
                f.autocomplete('search', '');
                f.focus()
            })
        },
        _setOption: function (a, b) {
            jQuery.Widget.prototype._setOption.apply(this, arguments)
        },
        destroy: function () {
            this.input.remove();
            this.button.remove();
            this.element.show();
            jQuery.Widget.prototype.destroy.call(this)
        }
    });
    
  jQuery.fn.buildVertexToggle = function() {
    return jQuery(this).find('.vItem').find('input:radio:first').each(function() {
      jQuery(this).parent('div').find('input').hide();
      var a = jQuery(this);
      a.hide().parent('div').css({'font-size':'0'});
      if(a.attr('id').length) {
        a.vertexToggle({
          onClickOff: function () {
            jQuery(this).parent('div').find('input:last').prop('checked', 'checked');
          },
          onClickOn: function () {
            jQuery(this).parent('div').find('input:first').prop('checked', 'checked');
          }
        });
      }
    });
  };
    jQuery.fn.buildVertexColorpicker = function() {
        return jQuery(this).find('.vItem').find('input:text').each(function (i) {
            var hash = '';
            var d = jQuery(this);
            if (d.attr('size') == 6 || d.attr('size') == 7) {
                var s = d.attr('size');
                var e = d.attr('id');
                if (e.length) {
                    var f = d.val();
                    if (s == 6) {
                        d.parent('div').append('<div class="color-holder" style="z-index:9;"><' + 'div id="colorSelector' + i + '"><div class="colorp-box" style="background-color:#' + f + ';"></div></div></div>')
                    } else if(s == 7) {
                        hash = '#';
                        d.parent('div').append('<div class="color-holder" style="z-index:9;"><' + 'div id="colorSelector' + i + '"><div class="colorp-box" style="background-color:' + f + ';"></div></div></div>')
                    }
                    jQuery('#colorSelector' + i).ColorPicker({
                        color: '#000000',
                        onShow: function (a) {
                            jQuery(a).fadeIn(500);
                            return false
                        },
                        onSubmit: function (hsb, hex, rgb, el) {
                            jQuery(el).ColorPickerHide();
                            return false
                        },
                        onHide: function (a) {
                            jQuery(a).fadeOut(500);
                            return false
                        },
                        onChange: function (a, b, c) {
                            jQuery('input#' + e).attr('value', hash + b);
                            d.parent('div').children('div').children('div').children('div.colorp-box').css('backgroundColor', '#' + b);
                            jQuery('html').find('.' + e).css('backgroundColor', '#' + b)
                        }
                    });
                    i++;
                }
            }
        });
    };
    jQuery.fn.fixVertexTooltips = function() {
        return jQuery(this).find('.vertex-admin-panel').each(function (i) {
            var m = jQuery(this).children('div');
            m.find('span.vFloatDesc').css('top', 0);
            var count = jQuery(this).children('div').size();
            if (count < 2) {
                var a = jQuery(this).children('div').filter(":last");
                a.find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
            }
            if (count < 3) {
                var a = jQuery(this).children('div').filter(":last");
                a.find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
                a.prev().find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
            }
            if (count < 4) {
                var a = jQuery(this).children('div').filter(":last");
                a.find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
                a.prev().find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
                a.prev().prev().find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
            }
            if (count > 3) {
                var a = jQuery(this).children('div').filter(":last");
                a.find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
                a.prev().find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
                a.prev().prev().find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
            }
            if (count > 4) {
                a.prev().prev().prev().find('span.vFloatDesc').attr('style', '').css('bottom', 0).hide();
            }
        });
    };
    jQuery.fn.buildVertexTooltips = function(c) {
        return jQuery(this).find('.vItem').find('.vItemName').each(function (i) {
            var a = jQuery(this);
            jQuery(a).find("span").hide()
            if (jQuery(a).find("span").text() != '') {
                var b = jQuery('<img src="' + c + '/help.png" height="24" width="24" alt="Info" />').css({
                    'float': 'right',
                    'position': 'relative',
                    'right': '5px',
                    'margin': '0 0 5px'
                });
                jQuery(b).mouseenter(function () {
                    if (jQuery(a).find("span.vFloatDesc").css('opacity') != 0) {
                        jQuery(a).find("span.vFloatDesc").css('opacity', '0')
                    }
                    jQuery(a).find("span.vFloatDesc").css('opacity', '1');
                    jQuery(a).find("span.vFloatDesc").stop().fadeIn(350)
                }).mouseleave(function () {
                    jQuery(a).find("span.vFloatDesc").stop().fadeOut(350);
                    jQuery(a).find("span.vFloatDesc").css('opacity', '0')
                });
                jQuery(a).append(b);
                
            }
        });
    };
    jQuery.fn.buildVertexMultiple = function(items) {
      //return jQuery(this).find('.vItem').find('select').filter(function(){if(jQuery(this).attr('multiple')) return true;}).width(310).multiselect().multiselectfilter();
      
        return jQuery(this).find('.vItem').find('select').each(function (i) {
            var a = jQuery(this);
            var b = a.attr('id');
            if (a.attr('multiple')) {
                if (b.length) {
                    /*if (b.match('component_items')) {
                        a.empty();
                        var select = jQuery('<select />').attr({id: b, multiple: 'multiple'});
                        jQuery.each(items, function(i, v){
                            var option = jQuery('<option />').val(i).text(v.text);
                            if(v.selected) {
                                option.attr('selected', 'selected');
                            }
                            a.append(option);
                            //console.log('Value: ' + i + ' Text: ' + v.text + ' Selected: ' + v.selected);
                        });
                        jQuery(a).coolMultiple({
                            delText: 'remove'
                        });
                        var selectAll = jQuery('<div />').text('Select All').css('cursor', 'pointer').addClass('selectall').click(function(){
                            if(jQuery(this).hasClass('selectall')) {
                                jQuery(this).removeClass('selectall').addClass('unselectall');
                                jQuery(this).text('Unselect All');
                                a.next('div').find('p').each(function () {
                                    var val = jQuery(this).attr('id').split('_o_')[1];
                                    if (!jQuery(this).hasClass('multis-selected')) {
                                        jQuery(this).trigger('click');
                                    }
                                });
                            } else {
                                jQuery(this).removeClass('unselectall').addClass('selectall');
                                jQuery(this).text('Select All');
                                a.next('div').find('p').each(function () {
                                    var val = jQuery(this).attr('id').split('_o_')[1];
                                    if (jQuery(this).hasClass('multis-selected')) {
                                        jQuery(this).trigger('click');
                                    }
                                });
                            }
                        });
                        jQuery(a).before(selectAll);
                    } else if(b.match('mult_select')) {
                      
                    } else {*/
                        jQuery(a).coolMultiple({
                            delText: 'remove'
                        });
                    //}
                    
                    i++;
                }
            }
        });
    };
    jQuery.fn.buildVertexAutoComplete = function() {
        return jQuery(this).find('.vItem').find('select').each(function (i) {
            var a = jQuery(this);
            var b = a.attr('id');
            if (!a.attr('multiple')) {
                if (b.length) {
                    if (b.match('fonts') || b.match('font')) {
                        jQuery(a).combobox();
                        i++;
                    }
                }
            }
        });
    };
    jQuery.fn.buildVertexAjaxAutoComplete = function(url) {
        return jQuery(this).find('.vItem').find('input:text').each(function (i) {
            var f = jQuery(this);
            if(f.attr('autocomplete') && f.attr('autocomplete') == 'off') return;
            //console.log(f);
            var g = f.attr('id');
            if (g.match('other')) {
                if (g.length) {
                    var k = jQuery('#' + g).autocomplete({
                        source: function (d, e) {
                            jQuery.ajax({
                                type: 'POST',
                                url: url,
                                dataType: 'json',
                                data: {
                                    search: true,
                                    term: d.term
                                },
                                success: function (b, c) {
                                    e(jQuery.map(b, function (a) {
                                        return {label: a.key,value: a.value}
                                    }));
                                }
                            });
                        },
                        minLength: 0,
                        delay: 0,
                        select: function (a, b) {
                            q(b.item ? 'Selected: ' + b.item.label + ' the base module name for this position is ' + b.item.value : 'Nothing selected, input was ' + this.value);
                        },
                        open: function (a, b) {
                            jQuery(this).autocomplete("resizemenu", j);
                        }
                    });
                    var l = jQuery('<' + 'div />').addClass('drop-button').attr('title', 'Show All Items').toggle(function () {
                        jQuery(k).autocomplete('option', 'minLength', 0);
                        jQuery(this).prev('input:text').autocomplete('search', '');
                        jQuery(k).autocomplete('option', 'minLength', o);
                    }, function () {
                        jQuery(this).prev('input:text').autocomplete('close');
                    });
                    f.after(l);
                    i++;
                }
            }
        });
    };
    jQuery.fn.updateInput = function(vals) {
        var id = jQuery(this);
        var val = id.val();
        val = val.split(',');
        var newVals = [];
        newVals[0] = (vals[0] ? vals[0] : val[0]);
        newVals[1] = (vals[1] ? vals[1] : val[1]);
        newVals[2] = (vals[2] ? vals[2] : val[2]);
        newVals[3] = (vals[3] ? vals[3] : val[3]);
        newVals[4] = (vals[4] ? vals[4] : val[4]);
        newVals[5] = (vals[5] ? vals[5] : val[5]);
        newVals = newVals.join(',');
        id.val(newVals);
    };
    jQuery.fn.refreshInput = function(vals) {
        var id = jQuery(this);
        var newVals = [];
        newVals[0] = vals[0];
        newVals[1] = vals[1];
        newVals[2] = vals[2];
        newVals[3] = vals[3];
        newVals[4] = vals[4];
        newVals[5] = vals[5];
        newVals = newVals.join(',');
        id.val(newVals);
    };
    jQuery.fn.makeError = function(type, vals) {
        var calc = Number(vals[0]) + Number(vals[1]) + Number(vals[2]) + Number(vals[3]) + Number(vals[4]) + Number(vals[5]);
        var msg = 'Im sorry but ' + vals[0] + ' + ' + vals[1] + ' + ' + vals[2] + ' + ' + vals[3] + ' + ' + vals[4] + ' + ' + vals[5] + ' only equals ' + calc + '% it must equal 100%';
        return msg;
    };
    jQuery.fn.sliderCalc = function(vals) {
        var calc = [];
        calc[0] = Number(vals[0]);
        calc[1] = Number(vals[0])+Number(vals[1]);
        calc[2] = Number(vals[0])+Number(vals[1])+Number(vals[2]);
        calc[3] = Number(vals[0])+Number(vals[1])+Number(vals[2])+Number(vals[3]);
        calc[4] = Number(vals[0])+Number(vals[1])+Number(vals[2])+Number(vals[3])+Number(vals[4]);
        calc[5] = Number(vals[0])+Number(vals[1])+Number(vals[2])+Number(vals[3])+Number(vals[4])+Number(vals[5]);
        return calc;
    };
    jQuery.fn.buildVertexSelects = function() {
        return jQuery(this).find('.vItem').find('select').each(function (i) {
            var a = jQuery(this);
            var b = a.attr('id');
            if (!a.attr('multiple') && !b.match('calculation')) {
                if (b.length) {
                    if (!b.match('fonts')) {
                        jQuery(a).combobox();
                        i++;
                    }
                }
            }
        });
    };
    
    jQuery.fn.buildVertexModuleSlider = function(autoSelectVal, manualSelectVal) {
        return jQuery(this).find('.vItem').find('textarea[id$="manual_widths"]').each(function (i) {
            var base = jQuery(this);
            var id = base.attr('id');
            base.hide();
            var currentArray = [];
            var setArray = [];
            var currentVal = jQuery(this).val();
            var num = 0;
            currentVal = currentVal.split(',');
            jQuery.each(currentVal, function (a, b) {
                currentArray[a] = b;
            });
            
            var block1 = jQuery('<div />').addClass('slider-val').css({width: currentArray[0] + '%'}).text(currentArray[0] + '%').hide();
            var block2 = jQuery('<div />').addClass('slider-val').css({width: currentArray[1] + '%'}).text(currentArray[1] + '%').hide();
            var block3 = jQuery('<div />').addClass('slider-val').css({width: currentArray[2] + '%'}).text(currentArray[2] + '%').hide();
            var block4 = jQuery('<div />').addClass('slider-val').css({width: currentArray[3] + '%'}).text(currentArray[3] + '%').hide();
            var block5 = jQuery('<div />').addClass('slider-val').css({width: currentArray[4] + '%'}).text(currentArray[4] + '%').hide();
            var block6 = jQuery('<div />').addClass('slider-val').css({width: currentArray[5] + '%'}).text(currentArray[5] + '%').hide();
            
            var slider_adv = jQuery('<a />').attr({id: id + '_adv',href: 'javascript:void(0);'}).addClass('slider-advanced').append('<span />');
            var slider_error = jQuery('<div />').attr('id', id + '_error').addClass('slider-bar-error').css({width: '100%',height: 20}).hide();
            var slider_preview = jQuery('<div />').attr('id', id + '_top').addClass('slider-preview-box').append(block1).append(block2).append(block3).append(block4).append(block5).append(block6);
            
            var slider_bar = jQuery('<div />').attr('id', id).addClass('slider-bar');
            var slider_wrap = jQuery('<div />').attr('id', id + '_base').addClass('slider-base').append(slider_adv).append(slider_preview).append(slider_bar).append(slider_error).hide();
            
            jQuery(this).after(slider_wrap);
            var select = base.parent().parent('div.vItem').prev('div.vItem').find('select');
            var select_val = select.children('option:selected').val();
            
            var show = false;
            var calc = [];
            if (select_val == autoSelectVal) {base.parent().parent('div.vItem').hide();}
            if (select_val == manualSelectVal) {base.show();}
            if (select_val == 1) {
                show = false;
                calc[0] = 100;
                base.parent().parent('div.vItem').hide();
            }
            if (select_val > 1) {
                show = true;
                calc[0] = Number(currentVal[0]);
                calc[1] = Number(currentVal[0]) + Number(currentVal[1]);
                block1.show();
                block2.show();
                base.parent().parent('div.vItem').show();
                slider_wrap.show();
            }
            if (select_val > 2) {
                show = true;
                calc[2] = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]);
                block3.show();
            }
            if (select_val > 3) {
                show = true;
                calc[3] = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]);
                block4.show();
            }
            if (select_val > 4) {
                show = true;
                calc[4] = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]);
                block5.show();
            }
            if (select_val > 5) {
                show = true;
                calc[5] = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]) + Number(currentVal[5]);
                block6.show();
            }
            var slider = jQuery('<div />').prop('slide',null).attr('id', id + '_slider').slider({
                range: true,
                min: 0,
                max: 100,
                step: 1,
                animate: false,
                disabled: false,
                values: calc,
                slide: function (a, b) {
                    if (b.values[0]) {
                        currentVal[0] = b.values[0];
                        block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                    }
                    if (b.values[1]) {
                        currentVal[1] = b.values[1] - b.values[0];
                        block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                    }
                    if (b.values[2]) {
                        currentVal[2] = b.values[2] - b.values[1];
                        block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                    }
                    if (b.values[3]) {
                        currentVal[3] = b.values[3] - b.values[2];
                        block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                    }
                    if (b.values[4]) {
                        currentVal[4] = b.values[4] - b.values[3];
                        block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                    }
                    if (b.values[5]) {
                        currentVal[5] = b.values[5] - b.values[4];
                        block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                    }
                    base.updateInput(currentVal);
                    //console.log(jQuery(this), jQuery(this).parent());
                    //jQuery(this).attr('style', '').parent().attr('style', '');
                    
                }
            });
            slider.find('a:first').text('1').next('a').text('2').next('a').text('3').next('a').text('4').next('a').text('5');
            slider_bar.append(slider);
            slider.find('a:last').hide();
            slider_preview.find('div').filter(':visible').filter(':last').addClass('last');
            slider_adv.bind('click', function () {
                var input1 = jQuery('<input />').addClass('inline-input').attr({size: 2}).val(currentVal[0]).hide();
                var input2 = jQuery('<input />').addClass('inline-input').attr({size: 2}).val(currentVal[1]).hide();
                var input3 = jQuery('<input />').addClass('inline-input').attr({size: 2}).val(currentVal[2]).hide();
                var input4 = jQuery('<input />').addClass('inline-input').attr({size: 2}).val(currentVal[3]).hide();
                var input5 = jQuery('<input />').addClass('inline-input').attr({size: 2}).val(currentVal[4]).hide();
                var input6 = jQuery('<input />').addClass('inline-input').attr({size: 2}).val(currentVal[5]).hide();
                
                block1.empty().append(input1);
                block2.empty().append(input2);
                block3.empty().append(input3);
                block4.empty().append(input4);
                block5.empty().append(input5);
                block6.empty().append(input6);
                
                input1.fadeIn(1000).css({'display': 'inline'});
                input2.fadeIn(1000).css({'display': 'inline'});
                input3.fadeIn(1000).css({'display': 'inline'});
                input4.fadeIn(1000).css({'display': 'inline'});
                input5.fadeIn(1000).css({'display': 'inline'});
                input6.fadeIn(1000).css({'display': 'inline'});
                
                input1.bind('keyup', function () {
                    currentVal[0] = jQuery(this).val();
                    var check = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]) + Number(currentVal[5]);
                    if (Math.round(check) != 100) {
                        var error = jQuery().makeError('error', currentVal);
                        slider_error.text(error).fadeIn(500);
                    } else if (Math.round(check) == 100) {
                        slider_error.fadeOut(500).empty();
                        base.updateInput(currentVal);
                        var change = jQuery().sliderCalc(currentVal);
                        block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                        block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                        block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                        block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                        block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                        block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                        slider_bar.children().slider('option', 'values', change);
                    }
                });
                input2.bind('keyup', function () {
                    currentVal[1] = jQuery(this).val();
                    var check = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]) + Number(currentVal[5]);
                    if (Math.round(check) != 100) {
                        var error = jQuery().makeError('error', currentVal);
                        slider_error.text(error).fadeIn(500);
                    } else if (Math.round(check) == 100) {
                        slider_error.fadeOut(500).empty();
                        base.updateInput(currentVal);
                        var change = jQuery().sliderCalc(currentVal);
                        block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                        block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                        block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                        block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                        block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                        block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                        slider_bar.children().slider('option', 'values', change);
                    }
                });
                input3.bind('keyup', function () {
                    currentVal[2] = jQuery(this).val();
                    var check = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]) + Number(currentVal[5]);
                    if (Math.round(check) != 100) {
                        var error = jQuery().makeError('error', currentVal);
                        slider_error.text(error).fadeIn(500);
                    } else if (Math.round(check) == 100) {
                        slider_error.fadeOut(500).empty();
                        base.updateInput(currentVal);
                        var change = jQuery().sliderCalc(currentVal);
                        block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                        block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                        block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                        block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                        block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                        block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                        slider_bar.children().slider('option', 'values', change);
                    }
                });
                input4.bind('keyup', function () {
                    currentVal[3] = jQuery(this).val();
                    var check = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]) + Number(currentVal[5]);
                    if (Math.round(check) != 100) {
                        var error = jQuery().makeError('error', currentVal);
                        slider_error.text(error).fadeIn(500);
                    } else if (Math.round(check) == 100) {
                        slider_error.fadeOut(500).empty();
                        base.updateInput(currentVal);
                        var change = jQuery().sliderCalc(currentVal);
                        block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                        block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                        block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                        block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                        block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                        block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                        slider_bar.children().slider('option', 'values', change);
                    }
                });
                input5.bind('keyup', function () {
                    currentVal[4] = jQuery(this).val();
                    var check = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]) + Number(currentVal[5]);
                    if (Math.round(check) != 100) {
                        var error = jQuery().makeError('error', currentVal);
                        slider_error.text(error).fadeIn(500);
                    } else if (Math.round(check) == 100) {
                        slider_error.fadeOut(500).empty();
                        base.updateInput(currentVal);
                        var change = jQuery().sliderCalc(currentVal);
                        block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                        block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                        block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                        block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                        block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                        block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                        slider_bar.children().slider('option', 'values', change);
                    }
                });
                input6.bind('keyup', function () {
                    currentVal[5] = jQuery(this).val();
                    var check = Number(currentVal[0]) + Number(currentVal[1]) + Number(currentVal[2]) + Number(currentVal[3]) + Number(currentVal[4]) + Number(currentVal[5]);
                    if (Math.round(check) != 100) {
                        var error = jQuery().makeError('error', currentVal);
                        slider_error.text(error).fadeIn(500);
                    } else if (Math.round(check) == 100) {
                        slider_error.fadeOut(500).empty();
                        base.updateInput(currentVal);
                        var change = jQuery().sliderCalc(currentVal);
                        block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                        block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                        block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                        block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                        block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                        block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                        slider_bar.children().slider('option', 'values', change);
                    }
                });
            });
            select.sizeslider({
                width: 500,
                curval: 'automatic',
                selected: function (c, d) {
                    block1.hide();
                    block2.hide();
                    block3.hide();
                    block4.hide();
                    block5.hide();
                    block6.hide();
                    slider_wrap.hide();
                    var f = [];
                    base.updateInput(f);
                    slider_bar.children().slider('destroy').remove();
                    var g = d.item.value;
                    if (g == autoSelectVal) {
                        currentVal[0] = 0;
                        currentVal[1] = 0;
                        currentVal[2] = 0;
                        currentVal[3] = 0;
                        currentVal[4] = 0;
                        currentVal[5] = 0;
                        base.parent().parent('div.vItem').hide();
                        base.hide();
                    }
                    if (g == manualSelectVal) {base.parent().parent('div.vItem').fadeIn(500);base.fadeIn(500);}
                    if (g == 1) {base.parent().parent('div.vItem').hide();}
                    if (g > 0 && g != autoSelectVal) {
                        currentVal[0] = 100;
                        currentVal[1] = 0;
                        currentVal[2] = 0;
                        currentVal[3] = 0;
                        currentVal[4] = 0;
                        currentVal[5] = 0;
                        f[0] = 100;
                        block1.text(100 + '%').css({width: 100 + '%'});
                        base.hide();
                    }
                    if (g > 1 && g != autoSelectVal) {
                        currentVal[0] = 50;
                        currentVal[1] = 50;
                        currentVal[2] = 0;
                        currentVal[3] = 0;
                        currentVal[4] = 0;
                        currentVal[5] = 0;
                        f[0] = 50;
                        f[1] = 50 * 2;
                        block1.text(50 + '%').css({width: 50 + '%'});
                        block2.text(50 + '%').css({width: 50 + '%'});
                        block3.text(0 + '%').css({width: 0 + '%'});
                        block4.text(0 + '%').css({width: 0 + '%'});
                        block5.text(0 + '%').css({width: 0 + '%'});
                        block6.text(0 + '%').css({width: 0 + '%'});
                        block1.show();
                        block2.show();
                        base.parent().parent('div.vItem').fadeIn(500);
                        slider_wrap.fadeIn(500);
                    }
                    if (g > 2 && g != autoSelectVal) {
                        currentVal[0] = 33.3;
                        currentVal[1] = 33.3;
                        currentVal[2] = 33.3;
                        currentVal[3] = 0;
                        currentVal[4] = 0;
                        currentVal[5] = 0;
                        f[0] = 33.3;
                        f[1] = 33.3 * 2;
                        f[2] = 33.3 * 3;
                        block1.text(33 + '%').css({width: 33 + '%'});
                        block2.text(33 + '%').css({width: 33 + '%'});
                        block3.text(33 + '%').css({width: 33 + '%'});
                        block4.text(0 + '%').css({width: 0 + '%'});
                        block5.text(0 + '%').css({width: 0 + '%'});
                        block6.text(0 + '%').css({width: 0 + '%'});
                        block1.show();
                        block2.show();
                        block3.show();
                        base.parent().parent('div.vItem').fadeIn(500);
                        slider_wrap.fadeIn(500);
                    }
                    if (g > 3 && g != autoSelectVal) {
                        currentVal[0] = 25;
                        currentVal[1] = 25;
                        currentVal[2] = 25;
                        currentVal[3] = 25;
                        currentVal[4] = 0;
                        currentVal[5] = 0;
                        f[0] = 25;
                        f[1] = 25 * 2;
                        f[2] = 25 * 3;
                        f[3] = 25 * 4;
                        block1.text(25 + '%').css({width: 25 + '%'});
                        block2.text(25 + '%').css({width: 25 + '%'});
                        block3.text(25 + '%').css({width: 25 + '%'});
                        block4.text(25 + '%').css({width: 25 + '%'});
                        block5.text(0 + '%').css({width: 0 + '%'});
                        block6.text(0 + '%').css({width: 0 + '%'});
                        block1.show();
                        block2.show();
                        block3.show();
                        block4.show();
                        base.parent().parent('div.vItem').fadeIn(500);
                        slider_wrap.fadeIn(500);
                    }
                    if (g > 4 && g != autoSelectVal) {
                        currentVal[0] = 20;
                        currentVal[1] = 20;
                        currentVal[2] = 20;
                        currentVal[3] = 20;
                        currentVal[4] = 20;
                        currentVal[5] = 0;
                        f[0] = 20;
                        f[1] = 20 * 2;
                        f[2] = 20 * 3;
                        f[3] = 20 * 4;
                        f[4] = 20 * 5;
                        block1.text(20 + '%').css({width: 20 + '%'});
                        block2.text(20 + '%').css({width: 20 + '%'});
                        block3.text(20 + '%').css({width: 20 + '%'});
                        block4.text(20 + '%').css({width: 20 + '%'});
                        block5.text(20 + '%').css({width: 20 + '%'});
                        block6.text(0 + '%').css({width: 0 + '%'});
                        block1.show();
                        block2.show();
                        block3.show();
                        block4.show();
                        block5.show();
                        base.parent().parent('div.vItem').fadeIn(500);
                        slider_wrap.fadeIn(500);
                    }
                    if (g > 5 && g != autoSelectVal) {
                        currentVal[0] = 16.66;
                        currentVal[1] = 16.66;
                        currentVal[2] = 16.66;
                        currentVal[3] = 16.66;
                        currentVal[4] = 16.66;
                        currentVal[5] = 16.66;
                        f[0] = 16.66;
                        f[1] = 16.66 * 2;
                        f[2] = 16.66 * 3;
                        f[3] = 16.66 * 4;
                        f[4] = 16.66 * 5;
                        f[5] = 16.66 * 6;
                        block1.text(16.6 + '%').css({width: 16.6 + '%'});
                        block2.text(16.6 + '%').css({width: 16.6 + '%'});
                        block3.text(16.6 + '%').css({width: 16.6 + '%'});
                        block4.text(16.6 + '%').css({width: 16.6 + '%'});
                        block5.text(16.6 + '%').css({width: 16.6 + '%'});
                        block6.text(16.6 + '%').css({width: 16.6 + '%'});
                        block1.show();
                        block2.show();
                        block3.show();
                        block4.show();
                        block5.show();
                        block6.show();
                        base.parent().parent('div.vItem').fadeIn(500);
                        slider_wrap.fadeIn(500);
                    }
                    slider_bar.children().slider('option','values', f);
                    base.refreshInput(currentVal);
                    if (g != autoSelectVal && g > 1) {
                        var slider = jQuery('<div />').prop('slide',null).attr('id', id + '_slider').slider({
                            range: true,
                            min: 0,
                            max: 100,
                            step: 1,
                            disabled: false,
                            animate: false,
                            values: f,
                            slide: function (a, b) {
                                if (b.values[0]) {
                                    currentVal[0] = b.values[0];
                                    block1.text(Math.round(currentVal[0]).toString() + '%').css({width: currentVal[0] + '%'});
                                }
                                if (b.values[1]) {
                                    currentVal[1] = b.values[1] - b.values[0];
                                    block2.text(Math.round(currentVal[1]).toString() + '%').css({width: currentVal[1] + '%'});
                                }
                                if (b.values[2]) {
                                    currentVal[2] = b.values[2] - b.values[1];
                                    block3.text(Math.round(currentVal[2]).toString() + '%').css({width: currentVal[2] + '%'});
                                }
                                if (b.values[3]) {
                                    currentVal[3] = b.values[3] - b.values[2];
                                    block4.text(Math.round(currentVal[3]).toString() + '%').css({width: currentVal[3] + '%'});
                                }
                                if (b.values[4]) {
                                    currentVal[4] = b.values[4] - b.values[3];
                                    block5.text(Math.round(currentVal[4]).toString() + '%').css({width: currentVal[4] + '%'});
                                }
                                if (b.values[5]) {
                                    currentVal[5] = b.values[5] - b.values[4];
                                    block6.text(Math.round(currentVal[5]).toString() + '%').css({width: currentVal[5] + '%'});
                                }
                                base.updateInput(currentVal);
                            }
                        });
                        slider_bar.append(slider);
                        slider.find('a:last').hide();
                        slider.find('a:first').text('1').next('a').text('2').next('a').text('3').next('a').text('4').next('a').text('5');
                        slider.find('a').click(function () {
                            slider_error.fadeOut(200).empty();
                        });
                    }
                    slider_preview.find('div').removeClass('last');
                    slider_preview.find('div').filter(':visible').filter(':last').addClass('last');
                }
            });
        });
    };
    jQuery.fn.linkMenus = function() {
        var base = jQuery(this);
        var first_tab = base.find('.panel-tab:first').find('a').attr('href').replace('#','');
        base.find('ul').each(function(){
            jQuery(this).children('li').children('a').each(function () {
                var a = jQuery(this);
                var href = a.attr('href').replace('#','');
                //alert(href);
                a.data('panel', href);
                a.attr('href', 'javascript:void(0);');
                var savedPanel = jQuery.cookie('DFCurPanel');
                if(savedPanel) {
                    if(a.data('panel') == savedPanel) {
                        jQuery('#' + savedPanel).show(500);
                    }
                    if(savedPanel == first_tab) {
                        jQuery('#' + first_tab).show(500);
                    } else {
                        jQuery('#' + savedPanel).show(500);
                    }
                } else {
                    jQuery.cookie('DFCurPanel', first_tab);
                    jQuery('#' + first_tab).show(500);
                }
                a.click(function(){
                    base.find('ul').find('li').removeClass('active');
                    a.parent('li').addClass('active');
                    base.find('.vertex-admin-panel').filter(':visible').hide();
                    jQuery('#' + href).fadeIn(500);
                    jQuery.cookie('DFCurPanel', href);
                });
            });
        });
    };
    jQuery.fn.previewFonts = function(font) {
        for(i= 0; i < 40; i++) {
            font = font.replace('<strong>', '');
            font = font.replace('</strong>', '');
        }
        var family = font;
        for(i= 0; i < 5; i++) {
            font = font.replace(' ', '+');
        }
        var style_sheet = jQuery('<link href="http://fonts.googleapis.com/css?family=' + font + '&v2" rel="stylesheet" type="text/css" />');
        var style_inline = jQuery("<style type='text/css'>#font_preview {font-family: '" + family + "';font-size:18px;}</style>");
        var preview = jQuery('<div />').addClass('font-preview').text('This is a preview of your chosen font.');
        jQuery('#vertex_admin_form').find('#font_preview').empty().append(style_sheet).append(style_inline).append(preview);
    };
})(jQuery);